package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.EntidadGestoraColaboradoraDao;
import com.ejie.ab04b.model.EntidadGestoraColaboradora;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab04b78s00ServiceImpl generated by UDA, 11-Jan-2017 12:23:08.
 * 
 * @author UDA
 */

@Service(value = "ab04b78s00Service")
public class EntidadGestoraColaboradoraServiceServiceImpl implements EntidadGestoraColaboradoraService {

	@Autowired()
	private EntidadGestoraColaboradoraDao ab04b78s00Dao;

	/**
	 * Inserts a single row in the Ab04b78s00 table.
	 * 
	 *  ab04b78s00
	 *            Ab04b78s00
	 *  Ab04b78s00
	 *
	 * @param ab04b78s00 the ab 04 b 78 s 00
	 * @return the entidad gestora colaboradora
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EntidadGestoraColaboradora add(EntidadGestoraColaboradora ab04b78s00) {
		return this.ab04b78s00Dao.add(ab04b78s00);
	}

	/**
	 * Updates a single row in the Ab04b78s00 table.
	 * 
	 *  ab04b78s00
	 *            Ab04b78s00
	 *  Ab04b78s00
	 *
	 * @param ab04b78s00 the ab 04 b 78 s 00
	 * @return the entidad gestora colaboradora
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EntidadGestoraColaboradora update(EntidadGestoraColaboradora ab04b78s00) {
		return this.ab04b78s00Dao.update(ab04b78s00);
	}

	/**
	 * Finds a single row in the Ab04b78s00 table.
	 * 
	 *  ab04b78s00
	 *            Ab04b78s00
	 *  Ab04b78s00
	 *
	 * @param ab04b78s00 the ab 04 b 78 s 00
	 * @return the entidad gestora colaboradora
	 */
	public EntidadGestoraColaboradora find(EntidadGestoraColaboradora ab04b78s00) {
		return (EntidadGestoraColaboradora) this.ab04b78s00Dao.find(ab04b78s00);
	}

	/**
	 * Deletes a single row in the Ab04b78s00 table.
	 * 
	 *  ab04b78s00
	 *            Ab04b78s00
	 *
	 * @param ab04b78s00 the ab 04 b 78 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EntidadGestoraColaboradora ab04b78s00) {
		this.ab04b78s00Dao.remove(ab04b78s00);
	}

	/**
	 * Finds a list of rows in the Ab04b78s00 table.
	 * 
	 *  ab04b78s00
	 *            Ab04b78s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab04b78s00>
	 *
	 * @param ab04b78s00 the ab 04 b 78 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<EntidadGestoraColaboradora> findAll(EntidadGestoraColaboradora ab04b78s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<EntidadGestoraColaboradora>) this.ab04b78s00Dao.findAll(ab04b78s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab04b78s00 table using like.
	 * 
	 *  ab04b78s00
	 *            Ab04b78s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab04b78s00>
	 *
	 * @param ab04b78s00 the ab 04 b 78 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<EntidadGestoraColaboradora> findAllLike(EntidadGestoraColaboradora ab04b78s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<EntidadGestoraColaboradora>) this.ab04b78s00Dao.findAllLike(ab04b78s00, jqGridRequestDto,
				startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab04b78s00 table.
	 * 
	 *  filterAb04b78s00
	 *            Ab04b78s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb04b78s00 the filter ab 04 b 78 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(EntidadGestoraColaboradora filterAb04b78s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		this.ab04b78s00Dao.removeMultiple(filterAb04b78s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab04b78s00 table.
	 * 
	 *  filterAb04b78s00
	 *            Ab04b78s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab04b78s00>
	 *
	 * @param filterAb04b78s00 the filter ab 04 b 78 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<EntidadGestoraColaboradora> filter(EntidadGestoraColaboradora filterAb04b78s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<EntidadGestoraColaboradora> listaAb04b78s00 = this.ab04b78s00Dao.findAllLike(filterAb04b78s00,
				jqGridRequestDto, false);
		Long recordNum = this.ab04b78s00Dao.findAllLikeCount(
				filterAb04b78s00 != null ? filterAb04b78s00 : new EntidadGestoraColaboradora(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<EntidadGestoraColaboradora>> reorderSelection = this.ab04b78s00Dao
					.reorderSelection(filterAb04b78s00, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<EntidadGestoraColaboradora>(jqGridRequestDto, recordNum, listaAb04b78s00,
					reorderSelection);
		}
		return new JQGridResponseDto<EntidadGestoraColaboradora>(jqGridRequestDto, recordNum, listaAb04b78s00);
	}

	/**
	 * Searches rows in the Ab04b78s00 table.
	 * 
	 *  filterAb04b78s00
	 *            Ab04b78s00
	 *  searchAb04b78s00
	 *            Ab04b78s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab04b78s00>>
	 *
	 * @param filterAb04b78s00 the filter ab 04 b 78 s 00
	 * @param searchAb04b78s00 the search ab 04 b 78 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<EntidadGestoraColaboradora>> search(EntidadGestoraColaboradora filterAb04b78s00,
			EntidadGestoraColaboradora searchAb04b78s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab04b78s00Dao.search(filterAb04b78s00, searchAb04b78s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab04b78s00 table.
	 * 
	 *  filterAb04b78s00
	 *            Ab04b78s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb04b78s00 the filter ab 04 b 78 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(EntidadGestoraColaboradora filterAb04b78s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab04b78s00Dao.reorderSelection(filterAb04b78s00, jqGridRequestDto, startsWith);
	}

}
